/* Najprej definiramo stevilo prastevil, ki jih zelimo izracunat. */
/* 100.000 je nekako "standardno" za testiranje hitrosti */

#define NOPRAST 100000

/* Potem nekaj pogojev ... */
/* Ce je definiran DEBUG, potem sproti izpisuje kaj pocne */
/* WANT_RESULTS doloca, da naj na koncu racunanja izpise rezultate na stdout */
/* VAX pa doloca, da prevajamo na VAX/VMS masini in ima drugace dolocen */
/* korak sistemskega timerja (druga simbolicna spremenljivka) */

/* #define DEBUG */
/* #define WANT_RESULTS */
/* #define VAX */


/* No, sedaj pa zares.... */

#include <stdio.h>
#include <math.h>
#include <stdlib.h>
#include <time.h>

main()
{
   long *stev,totest,n,i,rootl;
   char isprast;
   clock_t start,end;
   double divisor;

   if ((stev=malloc(NOPRAST*sizeof(long)))==NULL)
   {
      printf ("Error: Cannoot allocate enough memory!");
      exit (1);
   }

   stev[0]=1;
   stev[1]=2;
   stev[2]=3;
   stev[3]=5;
   n=4;

   totest=7;
   start=clock();

#ifdef DEBUG
   printf ("Testiram:      nasel:\n");
#endif

   while (n<NOPRAST)
   {

#ifdef DEBUG
      printf ("%9d  %7d\r",totest,n);
#endif

      rootl=sqrt((double)totest);
      rootl++;
      isprast=1;
      for (i=2;isprast&&(stev[i]<=rootl);++i)
         if (!(totest%stev[i])) isprast=0;
      if (isprast)
         stev[n++]=totest;

      totest+=2;
   }

   end=clock();

#ifdef WANT_RESULTS

   for (i=0;i<NOPRAST;i++)
      printf ("%7d %9d\n",i+1,stev[i]);
#endif

   free (stev);

#ifdef VAX
   divisor=CLK_TCK;
#else
   divisor=CLOCKS_PER_SEC;
#endif

   printf ("  Porabljen cas: %8.4fs\n",((double)end-start)/divisor);

   return (0);

}


